﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Drawing;

namespace memoQSampleCMSConnector
{
	public enum MessageType
	{
		Info,
		MajorInfo,
		Warning,
		Error
	}

	public class ColoredMessage
	{
		public string Message { get; set; }
		public Color Color { get; set; }
		public bool isPublished { get; set; }

		public ColoredMessage(string message, Color color)
		{
			isPublished = false;
			Message = message;
			Color = color;
		}
	}

	class Log
    {
        public static string logPath = Path.Combine(Path.GetTempPath(), "memoQSampleCMSConnector.txt");

        public static bool isLog = true;
		public static bool isProgress = true;

		public static List<ColoredMessage> messages = new List<ColoredMessage>();

		public static void AddLog(string logMessage, MessageType mtype = MessageType.Info)
        {
            logMessage = DateTime.Now.ToString("T") + "\t" + mtype.ToString() + "\t" + logMessage;

			if ((mtype == MessageType.Info && ConfigurationHelper.Config.loggingLevels[0] == 1) ||
					(mtype == MessageType.MajorInfo && ConfigurationHelper.Config.loggingLevels[1] == 1) ||
					(mtype == MessageType.Warning && ConfigurationHelper.Config.loggingLevels[2] == 1) ||
					(mtype == MessageType.Error && ConfigurationHelper.Config.loggingLevels[3] == 1))
			{
				if (isLog)
				{
					using (StreamWriter w = File.AppendText(logPath))
					{
						w.WriteLine(logMessage);
					}
				}

				if (isProgress)
				{
					Color color;
					switch (mtype)
					{
						case MessageType.Info:
							color = Color.LightSlateGray;
							break;
						case MessageType.MajorInfo:
							color = Color.Violet;
							break;
						case MessageType.Warning:
							color = Color.DarkBlue;
							break;
						case MessageType.Error:
							color = Color.OrangeRed;
							break;
						default:
							color = Color.LightSlateGray;
							break;
					}

					messages.Add(new ColoredMessage(logMessage, color));
					Program.mainWindow.RefreshMessages();

				}
			}
        }
    }
}